<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Serverstats extends CheckAction {

    public function action_index()
    {
        $serverstats = $this->getStats();
        $problems = $this->getProblems();
        
        $this->template->content = View::factory('serverstats/v_index')
            ->bind('serverstats', $serverstats)
            ->bind('problems', $problems);
    }
    
    public function action_get_stats()
    {
        if ( ! $this->request->is_ajax() )
        {
            throw HTTP_Exception::factory(405)->allowed(array(Request::GET));
        }
        
        try
        {
            $result = $this->getStats();
        }
        catch(Exception $e)
        {
            $code = $e instanceof HTTP_Exception ? $e->getCode() : 500;
            $this->response->status($code);
            
            $result = array(
                'errorMsg' => $e->getMessage(),
            );
        }
        
        $this->auto_render = false;
        $this->response->headers('Content-Type', 'application/json; charset=' . Kohana::$charset);
        $this->response->body(json_encode($result));
    }
    
    protected function getStats()
    {
        $result = array();

        $serverstats = ORM::factory('Serverstat')
            ->order_by('order')
            ->find_all();
        foreach($serverstats as $i => $serverstat)
        {
            foreach(array_keys($serverstat->table_columns()) as $key)
            {
                if ( 'value' == $key )
                {
                    $value = $serverstat->getValueFormatted();
                }
                else
                {
                    $value = $serverstat->$key;
                }
                
                if ( 'updated_at' == $key )
                {
                    $value = $this->colorizeUpdatedAt($value);
                }
                
                $result[$i][$key] = $value;
            }
        }
        
        return $result;
    }
    
    protected function colorizeUpdatedAt($value)
    {
        $updateAt = new DateTime($value);
        $updatedAgo = time() - $updateAt->getTimestamp();
        $value = Helper::time_elapsed_string($updateAt);
        if ( $updatedAgo <= 120 )
        {
            $value = '<span class="text-success">' . $value . '</span>';
        }
        elseif ( $updatedAgo <= 300 )
        {
            $value = '<span class="text-warning">' . $value . '</span>';
        }
        elseif ( $updatedAgo <= 600 )
        {
            $value = '<span class="text-danger">' . $value . '</span>';
        }
        else
        {
            $value = '<span class="text-danger"><strong>' . $value . '</strong></span>';
        }
        
        return $value;
    }

    public function action_get_problems()
    {
        if ( ! $this->request->is_ajax() ) {
            throw HTTP_Exception::factory(405)->allowed(array(Request::GET));
        }
        
        try {
            $result = [];
            $tmpProblems = $this->getProblems();
            foreach($tmpProblems as $problem) {
                $result[] = [
                    'id' => $problem->id,
                    'server' => $problem->server,
                    'filename' => $problem->filename,
                    'logline' => $problem->getLoglineFormatted(),
                    'description' => $problem->description,
                    'created_at' => $problem->created_at,
                ];
            }
        } catch(Exception $e) {
            $code = $e instanceof HTTP_Exception ? $e->getCode() : 500;
            $this->response->status($code);
            
            $result = array(
                'errorMsg' => $e->getMessage(),
            );
        }
        
        $this->auto_render = false;
        $this->response->headers('Content-Type', 'application/json; charset=' . Kohana::$charset);
        $this->response->body(json_encode($result));
    }
    
    protected function getProblems()
    {
        $problems = ORM::factory('Problem')
            ->scopeVisible()
            ->order_by('created_at', 'DESC')
            ->limit(500)
            ->find_all();
        
        return $problems;
    }
    
    public function action_delete_problem()
    {
        if ( ! $this->request->is_ajax() ) {
            throw HTTP_Exception::factory(405)->allowed(array(Request::GET));
        }
        
        try {
            $problem_id = (int)$this->request->post('problem_id');
            $problem = ORM::factory('Problem', $problem_id);
            if ( ! $problem->loaded()) {
                throw HTTP_Exception::factory(404);
            }
            
            $problem->deleted_at = date('Y-m-d H:i:s');
            $problem->save();
            $result = [
                'status' => 'ok',
            ];
        } catch(Exception $e) {
            $code = $e instanceof HTTP_Exception ? $e->getCode() : 500;
            $this->response->status($code);
            
            $result = [
                'errorMsg' => $e->getMessage(),
            ];
        }
        
        $this->auto_render = false;
        $this->response->headers('Content-Type', 'application/json; charset=' . Kohana::$charset);
        $this->response->body(json_encode($result));
    }
    
}